
/*******************************************************************************/
/*  
	This script produces Tables B1, B2, and B3
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

//________________________________________________________________
// ASEC data 
use "../Data/CPS/clean_cps19.dta", clear

//________________________________________________________________
// LWFH and HPP
merge m:1 occ using "../Data/onet_occ_clean.dta"
keep if _merge == 3
drop _merge

//____________________________________________________________________
// Reverse so that we look at outcome positively correlated with LWFH
foreach var of varlist college top50 female employer_health own_home born_50states married is_citizen big_firm white fulltime old no_unemp {
	di "`var'"
	qui gen y_`var' = 1 - `var' 	
	
}

//________________________________________________________________
// LWFH* Table
preserve
	collapse (mean) y_* [iw=asecwt], by(low_wfh_binary)
	export delimited "../Tables/tableB1.csv", replace
restore

//________________________________________________________________
// HPP* Table
preserve
	collapse (mean) y_* [iw=asecwt], by(high_pp_binary)
	export delimited "../Tables/tableB2.csv", replace
restore

preserve

//_______________________________
// {LWFH} x {HPP} table
decode high_pp_binary , gen(pp_dummy)
decode low_wfh_binary, gen(wfh_dummy)
gen group = pp_dummy + "_" + wfh_dummy
collapse (mean) y_* [iw=asecwt], by(high_pp_binary low_wfh_binary)
xpose, format(%4.2f) varname clear

//_______________________________
// Clean
rename _varname Workercharacteristic
rename v1 HWFH_LPP
rename v2 LWFH_LPP
rename v3 HWFH_HPP
rename v4 LWFH_HPP
order Workercharacteristic HWFH_LPP HWFH_HPP LWFH_LPP LWFH_HPP
drop in 1/2

//_______________________________	
// Rename
gsort -LWFH_LPP
replace Workercharacteristic = "No " + substr(Workercharacteristic,3,.)
replace Workercharacteristic = "Below median wage" if Workercharacteristic=="No top50"
replace Workercharacteristic = "Male" if Workercharacteristic=="No female"
replace Workercharacteristic = "No employer healthcare" if Workercharacteristic=="No employer_health"
replace Workercharacteristic = "Rents home" if Workercharacteristic=="No own_home"	
replace Workercharacteristic = "No college degree" if Workercharacteristic=="No college"
replace Workercharacteristic = "Born outside US" if Workercharacteristic=="No born_50states"
replace Workercharacteristic = "Single" if Workercharacteristic=="No married"
replace Workercharacteristic = "Non-US citizen" if Workercharacteristic=="No is_citizen"
replace Workercharacteristic = "Small firm (<500 emp.)" if Workercharacteristic=="No big_firm"
replace Workercharacteristic = "Non-white" if Workercharacteristic=="No white"
replace Workercharacteristic = "Part-time employed" if Workercharacteristic=="No fulltime"
replace Workercharacteristic = "Age <50" if Workercharacteristic=="No old"
replace Workercharacteristic = "Unemployed at all last year" if Workercharacteristic=="No no_unemp"

//_______________________________
// Differences relative to HWFH_LPP
replace LWFH_HPP = round(LWFH_HPP - LWFH_LPP, 0.01)
replace LWFH_LPP = round(LWFH_LPP - HWFH_HPP, 0.01)
replace HWFH_HPP = round(HWFH_HPP - HWFH_LPP, 0.01)
replace HWFH_LPP = round(HWFH_LPP, 0.01)

format %2.1f ?WFH_?PP 

export delimited "../Tables/tableB3.csv", replace
// end
